/* Microchip Technology Inc. and its subsidiaries.  You may use this software 
 * and any derivatives exclusively with Microchip products. 
 * 
 * THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS".  NO WARRANTIES, WHETHER 
 * EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED 
 * WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS FOR A 
 * PARTICULAR PURPOSE, OR ITS INTERACTION WITH MICROCHIP PRODUCTS, COMBINATION 
 * WITH ANY OTHER PRODUCTS, OR USE IN ANY APPLICATION. 
 *
 * IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
 * INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
 * WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP HAS 
 * BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE.  TO THE 
 * FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL CLAIMS 
 * IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT OF FEES, IF 
 * ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS SOFTWARE.
 *
 * MICROCHIP PROVIDES THIS SOFTWARE CONDITIONALLY UPON YOUR ACCEPTANCE OF THESE 
 * TERMS. 
 */

/* 
 * File:   Filament Dryer
 * Author: Phil Prosser
 * Comments:
 * Revision history: 
 */

// This is a guard condition so that contents of this file are not included
// more than once.  
#ifndef XC_HEADER_TEMPLATE_H
#define	XC_HEADER_TEMPLATE_H

#include <xc.h> // include processor files - each processor file is guarded.  


#define _XTAL_FREQ 4000000

/* Useful Defines */
#define startup_delay 500   // give things time to sort themselve sout
#define settle_time 100   // give things time to sort themselve sout
#define timer_delay_ms 50
#define vent_delay_on_boot_time 500   // 3 seconds is long enouugh to be heard
#define short_vent_on_boot_time 500   // 3 seconds is long enouugh to be heard
#define Time_12hr_Runtime (9 * 60 * 60)  /* this is defintiely a long int */
#define Time_6hr_Runtime (6 * 60 * 60)  /* this is defintiely a long int */
#define Counting_Timer   1000           /* Use 1000ms time steps */
#define Vent_Runtime     (20)         /* 20 sec */
#define Vent_Interval    (10 * 60)      /* 10 minutes*/

typedef enum
{
	/* Application's state machine's initial state. */
	DRYER_STATE_INIT=0,         // Initial state
	DRYER_STATE_IDLE,           // Idle
    DRYER_STATE_COUNTING        // counting drying cycle
            
	/* TODO: Define states used by the application state machine. */
} DRYER_STATES;


typedef struct
{
    DRYER_STATES        state;              /* The application's current state */
    long int            Timer_Runtime;      /* Time to run - units 100ms */
    long int            Timer_Time;         /* Actual Time */
    long int            Timer_Temp;         /* Start time for set duration */
    long int            Vent_Timer;         /* timer for vent fan */
    long int            Second_Counter;     /* Timer for 1 second */
    int                 Heater_Output_Disable;  /* Heater output state 1 = OFF */ 
    int                 Vent_Fan_Output;    /* output for Vent Fan 1 = on */
} DRYER_DATA;

DRYER_DATA Dryer_Data;   /* refer defines in util.h */

/* define the PORA A bits here    */
/* Note io.c sets these port bits */
#define Run_Button_Addr     0x01    /* port A bit 0  <- input from switch*/
#define Vent_Fan_Addr       0x02    /* Port A bit 1 -> output to drive vent switch */
#define Heater_Enable_Addr  0x04    /* Port A bit 2 -> High enables heater */
#define Time_6h_Addr        0x10    /* Port A but 4 <- input LOW = 4 hours */
#define Time_12h_Addr        0x20    /* Port A but 5 <- input LOW = 8 hours */

#define Read_Port_A_Inputs (PORTA & (Run_Button_Addr + Time_6h_Addr + Time_12h_Addr))

#define Start_Read Run_Button_GetValue() 

#define Run_Vent_Fan  Vent_Fan_SetHigh() 
#define Stop_Vent_Fan Vent_Fan_SetLow() 

#define Run_Heater  Heater_Enable_SetLow()
#define Stop_Heater Heater_Enable_SetHigh()
#endif






#ifdef	__cplusplus
extern "C" {
#endif /* __cplusplus */

    // TODO If C++ is being used, regular C code needs function names to have C 
    // linkage so the functions can be used by the c code. 

#ifdef	__cplusplus
}
#endif /* __cplusplus */


